<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequestError extends Model 
{

    protected $table = 'order_request_error';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('builder');
    protected $visible = array('builder');

    public function order()
    {
        return $this->belongsTo('App\Models\Order');
    }

    public function cargoIntegration()
    {
        return $this->belongsTo('App\Models\Cargo\Integration', 'cargo_firm_integration_id');
    }

}